<?php

/**
 * Credits Controller
 * @author Andy Aliansah <andyaliansah97@gmail.com>
 */

use libraries\BaseController;

class Credits extends BaseController
{
	/**
	 * Constructor CodeIgniter
	 */
	public function __construct()
	{
		parent::__construct();
		$this->auth->check_auth();

		// load model
		$this->load->model('Credits_model');
		$this->load->model('Sales_orders_model');
		$this->load->model('Sales_returns_model');
		$this->load->model('Customers_model');
		$this->load->model('Banks_model');
		$this->load->model('Accounts_model');
	}

	/**
	 * Halaman Index
	 *
	 * @return HTML
	 */

	public function index()
	{
		$data['content_title'] = 'Pembayaran Piutang';

		$this->twiggy_display('adm/credits/index', $data);
	}

	public function get_data_header()
	{
		$data = [];
		$order = "credit_header_id DESC";
		$get_data = $this->Credits_model->credit_header('', $order)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {
				$data[] = array(
					'no'           => $no,
					'id'           => $get_row->credit_header_id,
					'number'       => $get_row->credit_header_number,
					'date'         => indonesian_date($get_row->credit_header_date),
					'customer'     => $get_row->customer_name,
					'sub_total'    => number_format($get_row->credit_header_sub_total),
					'return_total' => number_format($get_row->credit_header_return_total),
					'grand_total'  => number_format($get_row->credit_header_grand_total),
					'bayar_total'  => number_format($get_row->credit_header_bayar_total),
					'description'  => $get_row->credit_header_description,
				);
				$no++;
			}
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function edit($id = 'new')
	{
		$title = "Tambah Pembayaran Piutang";
		$header_data = array(null);

		$prefix  = "CR-TX";
		$datenow = date('Ym');
		$number_generator = $this->Credits_model->credit_autonumber();
		$autonumber = $prefix . $datenow . $number_generator;

		$date_text   = date_now();

		if ($id != 'new') {
			$title       = "Edit Pembayaran Piutang";
			$where       = array('credit_header_id' => $id);
			$header_data = $this->Credits_model->credit_header($where)->row_array();
			$autonumber  = $header_data['credit_header_number'];
			$date_text   = $header_data['credit_header_date'];
		}

		$data['id']            = $id;
		$data['content_title'] = $title;
		$data['header_data']   = $header_data;
		$data['customer_data'] = $this->Customers_model->get_data()->result();
		$data['bank_data']     = $this->Banks_model->get_data()->result();
		$data['account_data'] = $this->Accounts_model->get_data()->result();

		$data['autonumber'] = $autonumber;
		$data['date_text']  = $date_text;

		$this->twiggy_display('adm/credits/edit', $data);
	}

	public function get_data_detail()
	{
		$id = $this->input->post("id");
		$where       = array('credit_detail_header_id' => $id);
		$order       = array('sales_order_header_number' => 'asc');

		$data = [];
		$get_data = $this->Credits_model->credit_detail($where)->result();

		// ketika data tersedia
		// maka generate data json untuk Datatable
		if ($get_data) {
			$no = 1;
			foreach ($get_data as $get_row) {

				$data[] = array(
					'no'               => $no,
					'detail_id'        => $get_row->credit_detail_id,
					'detail_header_id' => $get_row->credit_detail_header_id,
					'id'               => $get_row->credit_detail_sales_order_header_id,
					'number'           => $get_row->sales_order_header_number,
					'date'             => indonesian_date($get_row->sales_order_header_date),
					'sub_total'        => number_format($get_row->credit_detail_price),
					'discount'         => number_format($get_row->credit_detail_discount_percentage),
					'discount_total'   => number_format($get_row->credit_detail_discount_total),
					'return_total'     => number_format($get_row->credit_detail_return_total),
					'total'            => number_format($get_row->credit_detail_total),
					'bayar'            => number_format($get_row->credit_detail_bayar),
				);
				$no++;
			}
		}

		output_json($data);
	}

	public function get_embed()
	{
		$data = [];
		$data['content_title'] = 'Data Penjualan';
		$this->twiggy_display('adm/credits/embed', $data);
	}

	public function get_data_embed()
	{
		$data     = [];
		$response = [];
		$id       = $this->input->post('id');
		$customer = $this->input->post('customer');
		$search   = $this->input->post('search');

		$type = ($id == 'new' ? 'new' : 'edit');
		$get_data  = $this->Credits_model->salesorder_headersearch($type, $customer, $search)->result();

		$no = 0;
		foreach ($get_data as $get_row) {
			$where        = array('sales_order_header_id' => $get_row->sales_order_header_id);
			$where_telah_bayar = array('credit_detail_sales_order_header_id' => $get_row->sales_order_header_id);
			$return_total = 0;
			$paid_total = 0;
			$disc_total = 0;
			$return_data  = $this->Credits_model->get_sum_retur($where)->row();
			$paid_data  = $this->Credits_model->get_sum_telah_bayar($where_telah_bayar)->row();
			if ($return_data) {
				$return_total = $return_data->total_retur;
			}
			if ($paid_data) {
				$paid_total = $paid_data->total_telah_bayar;
				$disc_total = $paid_data->total_disc;
			}
			$total = ($get_row->sales_order_header_grand_total - $return_total - $paid_total - $disc_total);
			$data[] = array(
				'no'           => $no,
				'id'           => $get_row->sales_order_header_id,
				'number'       => $get_row->sales_order_header_number,
				'date'         => indonesian_date($get_row->sales_order_header_date, 'd/m/Y'),
				'sub_total'    => number_format($get_row->sales_order_header_grand_total),
				'paid_total'   => number_format($paid_total + $disc_total),
				'return_total' => number_format($return_total + $paid_total + $disc_total),
				'total'        => number_format($total),
				'bayar'        => number_format(0),
			);

			$no++;
		}

		$response = [
			'data'         => $data,
			'recordsTotal' => count($data)
		];

		output_json($response);
	}

	public function save()
	{
		$id             = $this->input->post('id');
		$number         = $this->input->post("number");
		$date           = $this->input->post("date");
		$customer       = $this->input->post("customer");
		$payment_method = $this->input->post("payment_method");
		$bank           = $this->input->post("bank");
		$number_giro    = $this->input->post("number_giro");
		$payment_due    = $this->input->post("payment_due");
		$sub_total      = $this->input->post("sub_total");
		$return_total   = $this->input->post("return_total");
		$grand_total    = $this->input->post("grand_total");
		$bayar_total    = $this->input->post("bayar_total");
		$description    = $this->input->post("description");
		$account        = $this->input->post("account");

		$vuedata = $this->input->post('vuedata');
		$header_id   = $id;

		$payment_due_data  = ($payment_due == "" ? "0000-00-00" : change_format_date($payment_due));

		$header_data = [
			'credit_header_number'         => $number,
			'credit_header_date'           => change_format_date($date),
			'credit_header_customer_id'    => $customer,
			'credit_header_bank_id'        => $bank,
			'credit_header_account_id'     => $account,
			'credit_header_payment_method' => 0,
			'credit_header_number_giro'    => $number_giro,
			'credit_header_payment_due'    => $payment_due_data,
			'credit_header_sub_total'      => trims($sub_total),
			'credit_header_return_total'   => trims($return_total),
			'credit_header_grand_total'    => trims($grand_total),
			'credit_header_bayar_total'    => trims($bayar_total),
			'credit_header_description'    => $description
		];

		$detail_data = [];
		$update_lunas = [];

		// if save $id = new else update data
		if ($id == "new") {
			// save header
			$save_header = $this->Credits_model->save_header($header_data);
			if ($save_header) {
				$header_id = $this->db->insert_id();
				foreach ($vuedata as $row) {
					$detail_data[] = [
						'credit_detail_header_id'                => $header_id,
						'credit_detail_sales_order_header_id' => $row['id'],
						'credit_detail_price'                    => trims($row['sub_total']),
						'credit_detail_discount_percentage'      => trims($row['discount']),
						'credit_detail_discount_total'           => trims($row['discount_total']),
						'credit_detail_return_total'             => trims($row['return_total']),
						'credit_detail_total'                    => trims($row['total']),
						'credit_detail_bayar'                    => trims($row['bayar']),
					];

					// $data = array(
					// 	'status_paid'  => 1
					// );

					// $where = $row['id'];

					// $update_status_paid = $this->Sales_orders_model->update_header($where, $data);

					if (trims($row['total']) == trims($row['bayar'])) {
						$update_lunas[] = [
							'sales_order_header_id' => $row['id'],
							'status_paid'           => 1,
						];
					}
				}

				if (!empty($update_lunas)) {
					$update_lunas_so = $this->Sales_returns_model->update_lunas_so($update_lunas);
				}

				$save_detail = $this->Credits_model->save_detail($detail_data, true);

				if ($save_detail) {
					$msg    = "Berhasil menyimpan data";
					$status = "success";
				} else {
					$msg    = "Gagal menyimpan data";
					$status = "error";
				}
			} else {
				$msg    = "Gagal menyimpan data";
				$status = "error";
			}
		} else {

			$where_detail    = array('credit_detail_header_id' => $header_id);
			$get_data_detail = $this->Credits_model->credit_detail($where_detail)->result();
			foreach ($get_data_detail as $row_detail) {
				$data = array(
					'status_paid'  => 0
				);

				$where = $row_detail->credit_detail_sales_order_header_id;

				$update_status_paid = $this->Sales_orders_model->update_header($where, $data);
			}

			$delete_detail = $this->Credits_model->delete_detail($id);

			if ($delete_detail) {
				$save_header = $this->Credits_model->update_header($id, $header_data);

				if ($save_header) {
					// $header_id = $this->db->insert_id();
					foreach ($vuedata as $row) {
						$detail_data[] = [
							'credit_detail_header_id'                => $header_id,
							'credit_detail_sales_order_header_id' => $row['id'],
							'credit_detail_price'                    => trims($row['sub_total']),
							'credit_detail_discount_percentage'      => trims($row['discount']),
							'credit_detail_discount_total'           => trims($row['discount_total']),
							'credit_detail_return_total'             => trims($row['return_total']),
							'credit_detail_total'                    => trims($row['total']),
							'credit_detail_bayar'                    => trims($row['bayar']),
						];

						// $data = array(
						// 	'status_paid'  => 1
						// );

						// $where = $row['id'];

						// $update_status_paid = $this->Sales_orders_model->update_header($where, $data);
						if (trims($row['total']) == trims($row['bayar'])) {
							$update_lunas[] = [
								'sales_order_header_id' => $row['id'],
								'status_paid'           => 1,
							];
						}
					}

					if (!empty($update_lunas)) {
						$update_lunas_so = $this->Sales_returns_model->update_lunas_so($update_lunas);
					}

					$save_detail = $this->Credits_model->save_detail($detail_data, true);

					if ($save_detail) {
						$msg    = "Berhasil menyimpan data";
						$status = "success";
					} else {
						$msg    = "Gagal menyimpan data";
						$status = "error";
					}
				} else {
					$msg    = "Gagal menyimpan data";
					$status = "error";
				}
			} else {
				$msg    = "Gagal menyimpan data";
				$status = "error";
			}
		}

		$response = [
			'message' => $msg,
			'status'  => $status,
			'id'      => $header_id
		];
		output_json($response);
	}

	public function delete()
	{
		$id = $this->input->post('id');

		foreach ($id as $row) {
			$where_detail    = array('credit_detail_header_id' => $row);
			$get_data_detail = $this->Credits_model->credit_detail($where_detail)->result();
			foreach ($get_data_detail as $row_detail) {
				$data = array(
					'status_paid'  => 0
				);

				$where = $row_detail->credit_detail_sales_order_header_id;

				$update_status_paid = $this->Sales_orders_model->update_header($where, $data);
			}

			$delete_header = $this->Credits_model->delete_header($row);

			if ($delete_header) {
				$delete_type = $this->Credits_model->delete_detail($row);
			}
		}

		$response = array(
			'message' => 'Berhasil menghapus data',
			'status'  => 'success'
		);

		output_json($response);
	}

	public function print_out($id)
	{
		$where_header = array('credit_header_id' => $id);
		$where_detail = array('credit_detail_header_id' => $id);

		$header = $this->Credits_model->credit_header($where_header)->row_array();
		$detail = $this->Credits_model->credit_detail($where_detail)->result();

		$data['content_title'] = 'Print Invoice Pembelian';
		$data['header'] = $header;
		$data['detail'] = $detail;

		$this->twiggy_display('adm/credits/print_out', $data);
	}
}
